---
generated_at: 2026-01-21 10:30:00
metrics:
  claims_total: 10
  claims_with_evidence: 9
  claims_without_evidence: 1
confidence_derived: 0.90
---

# 根拠レポート：4-Hello World.ps1.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：9 / 10、根拠なし：1
- 優先レビュー（高）
  1. **MainModule.MsgInfoの仕様**：StaxRip本体コードの確認が必要
  2. **スクリプト実行環境**：StaxRipのスクリプティング機能の詳細仕様

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Source/Scripts/Hello World.ps1` 行1-2（スクリプト全体）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` 行5

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MainModuleクラスのMsgInfoメソッドを使用する | E-01 | ○ |
| C-02 | "Hello World"テキストを表示する | E-01 | ○ |
| C-03 | StaxRipアプリケーション内から実行される | E-02 | ○ |
| C-04 | サンプルスクリプトである | E-02 | ○ |
| C-05 | 情報ダイアログを表示する | E-01 | ○ |
| C-06 | パラメータを受け付けない | E-01 | ○ |
| C-07 | ファイル出力がない | E-01 | ○ |
| C-08 | データベース操作がない | E-01 | ○ |
| C-09 | Source/Scripts/ディレクトリに配置されている | E-02 | ○ |
| C-10 | MsgInfoは情報ダイアログを表示するAPIである | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- MainModule.MsgInfoメソッドの詳細仕様：スクリプト内の使用方法からは「情報メッセージを表示する」機能と推測されますが、StaxRip本体のソースコードを確認する必要があります
  - 候補：StaxRip本体のMainModuleクラス定義 / StaxRipのスクリプティングAPIドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - メッセージ表示のみの単純なサンプルスクリプト
- 0: 低リスク - ファイルやデータへの変更を行わない

## 6) レビュアーチェックリスト（最小）
- [ ] MsgInfoメソッドの動作が期待通りか確認（StaxRip内での実行テスト）
- [ ] スクリプトがStaxRipのスクリプト一覧に表示されるか確認
